import matplotlib.pyplot as plt
from matplotlib.patches import ConnectionPatch
import numpy as np
import matplotlib as mpl

def set_params():
	mpl.rcParams['savefig.dpi'] = 350

fig = plt.figure(figsize=(7, 4.0625))
ax1 = fig.add_subplot(121)
ax2 = fig.add_subplot(122)
fig.subplots_adjust(wspace=0)
set_params()

ratios = [.043,.957]
labels = ['mutated', 'correct']
explode = [0.15, 0]
angle = -180 * ratios[0]
color = [(1,0.188,0.188),(0.4,0.84,0)]
ax1.pie(ratios, autopct='%1.1f%%', startangle=angle,colors = color,
        labels=labels, explode=explode)

xpos = 0
bottom = 1
ratios = [4,2,1,1]
width = .15
colors = [[1, 0.647, 0],[1, 0.271, 0],[0.804, 0.522, 0.247],[0.933, 0.231, 0.231]]

for j in range(len(ratios)):
    height = ratios[j]/8
    ax2.bar(xpos, height, width, bottom = bottom-height, color=colors[j])
    ypos = bottom - ax2.patches[j].get_height() / 2
    bottom -= height
    ax2.text(xpos, ypos, "%s" % ratios[j],
             ha='center')

ax2.set_title('Types of mutation')
ax2.legend(('1bp insertion','1bp deletion','1bp substitution','severe mutation'),
	ncol = 1,bbox_to_anchor = (0.55,0.985),fontsize = 9.5,frameon = False)
ax2.axis('off')
ax2.set_xlim(- 5 * width, 5 * width)

theta1, theta2 = ax1.patches[0].theta1, ax1.patches[0].theta2
center, r = ax1.patches[0].center, ax1.patches[0].r
bar_height = sum([item.get_height() for item in ax2.patches])

x = r * np.cos(np.pi / 180 * theta2) + center[0]
y = np.sin(np.pi / 180 * theta2) + center[1]
con = ConnectionPatch(xyA=(- width / 2, bar_height), xyB=(x, y),
                      coordsA="data", coordsB="data", axesA=ax2, axesB=ax1)
con.set_color([0, 0, 0])
con.set_linewidth(1)
ax2.add_artist(con)

x = r * np.cos(np.pi / 180 * theta1) + center[0]
y = np.sin(np.pi / 180 * theta1) + center[1]
con = ConnectionPatch(xyA=(- width / 2, 0), xyB=(x, y), coordsA="data",
                      coordsB="data", axesA=ax2, axesB=ax1)
con.set_color([0, 0, 0])
ax2.add_artist(con)
con.set_linewidth(1)

plt.text(-2.3,0.05,'Unique gRNAs: 171',fontsize = 11)
plt.text(-1.4,0.05,'Duplicate gRNAs: 3',fontsize = 11)

plt.savefig('figure.pdf',format='pdf')

plt.show()